/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ai.selector.NPCInteractSelector;
import noppes.npcs.constants.AiMutex;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIWander
extends EntityAIBase {
    private final EntityNPCInterface npc;
    private EntityNPCInterface nearbyNPC;
    public Predicate<? super Entity> selector;
    private double x;
    private double y;
    private double zPosition;

    public EntityAIWander(EntityNPCInterface npcIn) {
        this.npc = npcIn;
        this.func_75248_a(AiMutex.PASSIVE);
        this.selector = new NPCInteractSelector(this.npc);
    }

    private EntityNPCInterface getNearbyNPC() {
        List list = this.npc.field_70170_p.func_175674_a((Entity)this.npc, this.npc.func_174813_aQ().func_72314_b((double)this.npc.ais.walkingRange, this.npc.ais.walkingRange > 7 ? 7.0 : (double)this.npc.ais.walkingRange, (double)this.npc.ais.walkingRange), this.selector);
        Iterator ita = list.iterator();
        while (ita.hasNext()) {
            EntityNPCInterface npc = (EntityNPCInterface)((Object)ita.next());
            if (npc.ais.stopAndInteract && !npc.isAttacking() && npc.func_70089_S() && !npc.faction.isAggressiveToNpc(npc)) continue;
            ita.remove();
        }
        if (list.isEmpty()) {
            return null;
        }
        return (EntityNPCInterface)((Object)list.get(this.npc.func_70681_au().nextInt(list.size())));
    }

    private Vec3d getVec() {
        if (this.npc.ais.walkingRange <= 0) {
            return RandomPositionGenerator.func_75463_a((EntityCreature)this.npc, (int)CustomNpcs.NpcNavRange, (int)7);
        }
        BlockPos start = new BlockPos((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos());
        int distance = (int)MathHelper.func_76133_a((double)this.npc.func_174818_b(start));
        int range = this.npc.ais.walkingRange - distance;
        if (range > CustomNpcs.NpcNavRange) {
            range = CustomNpcs.NpcNavRange;
        }
        if (range < 3) {
            if (distance > this.npc.ais.walkingRange) {
                distance = this.npc.ais.walkingRange;
            }
            if (distance > CustomNpcs.NpcNavRange) {
                distance = CustomNpcs.NpcNavRange;
            }
            for (int i = 0; i < 10; ++i) {
                double d2;
                double d1;
                double d0;
                int dist;
                Vec3d vec = RandomPositionGenerator.func_75463_a((EntityCreature)this.npc, (int)distance, (int)distance);
                if (vec == null || (dist = (int)MathHelper.func_76133_a((double)((d0 = (double)start.func_177958_n() - vec.field_72450_a) * d0 + (d1 = (double)start.func_177956_o() - vec.field_72448_b) * d1 + (d2 = (double)start.func_177952_p() - vec.field_72449_c) * d2))) > this.npc.ais.walkingRange) continue;
                return vec;
            }
            return new Vec3d((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos());
        }
        return RandomPositionGenerator.func_75463_a((EntityCreature)this.npc, (int)range, (int)Math.min(range, 7));
    }

    public void func_75251_c() {
        CustomNpcs.debugData.start((Object)this.npc);
        if (this.nearbyNPC != null && this.npc.isInRange((Entity)this.nearbyNPC, 3.5)) {
            Line line;
            EntityNPCInterface talk = this.npc;
            if (this.npc.func_70681_au().nextBoolean()) {
                talk = this.nearbyNPC;
            }
            if ((line = talk.advanced.getNPCInteractLine()) == null) {
                line = new Line("... ... ...");
            }
            line.setShowText(false);
            if (talk.func_70089_S()) {
                talk.saySurrounding(line);
            }
            this.npc.addInteract((EntityLivingBase)this.nearbyNPC);
            this.nearbyNPC.addInteract((EntityLivingBase)this.npc);
        }
        this.nearbyNPC = null;
        CustomNpcs.debugData.end((Object)this.npc);
    }

    public boolean func_75253_b() {
        return (this.nearbyNPC == null || this.selector.apply((Object)this.nearbyNPC) && !this.npc.isInRange((Entity)this.nearbyNPC, this.npc.field_70130_N)) && !this.npc.func_70661_as().func_75500_f() && this.npc.func_70089_S() && !this.npc.isInteracting();
    }

    public boolean func_75250_a() {
        CustomNpcs.debugData.start((Object)this.npc);
        if (this.npc.func_70654_ax() >= 100 || !this.npc.func_70661_as().func_75500_f() || this.npc.isInteracting() || this.npc.func_184218_aH() || this.npc.ais.movingPause && this.npc.func_70681_au().nextInt(80) != 0) {
            CustomNpcs.debugData.end((Object)this.npc);
            return false;
        }
        if (this.npc.ais.npcInteracting && this.npc.func_70681_au().nextInt(this.npc.ais.movingPause ? 6 : 16) == 1) {
            this.nearbyNPC = this.getNearbyNPC();
        }
        if (this.nearbyNPC != null) {
            this.x = MathHelper.func_76128_c((double)this.nearbyNPC.field_70165_t);
            this.y = MathHelper.func_76128_c((double)this.nearbyNPC.field_70163_u);
            this.zPosition = MathHelper.func_76128_c((double)this.nearbyNPC.field_70161_v);
            this.nearbyNPC.addInteract((EntityLivingBase)this.npc);
        } else {
            Vec3d vec = this.getVec();
            if (vec == null) {
                CustomNpcs.debugData.end((Object)this.npc);
                return false;
            }
            this.x = vec.field_72450_a;
            this.y = vec.field_72448_b;
            if (this.npc.ais.movementType == 1) {
                this.y = this.npc.getStartYPos() + (double)this.npc.func_70681_au().nextFloat() * 0.75 * (double)this.npc.ais.walkingRange;
            }
            this.zPosition = vec.field_72449_c;
        }
        CustomNpcs.debugData.end((Object)this.npc);
        return true;
    }

    public void func_75249_e() {
        this.npc.func_70661_as().func_75492_a(this.x, this.y, this.zPosition, 1.0);
    }

    public void func_75246_d() {
        if (this.nearbyNPC != null) {
            this.nearbyNPC.func_70661_as().func_75499_g();
        }
    }
}

